export const MODULE_ID = "ripper-premium-dice";

Hooks.on("init", () => {
    registerDice();
});

const TRACKED_SHADERS = [];

function registerDice() {
    Hooks.once("diceSoNiceReady", (dice3d) => {
        dice3d.addTexture("ripper-premium-dice-waves-white", {
            name: "Waves (The Ripper Premium Dice)",
            composite: "source-over",
            source: `modules/${MODULE_ID}/assets/blank.jpg`,
        });
    });

    Hooks.once("canvasReady", () => {
        canvas.app.ticker.add((delta) => {
            for (let shader of TRACKED_SHADERS) {
                shader.uniforms.time.value += delta;
            }
        });
    });

    Hooks.on("diceSoNiceShaderOnBeforeCompile", (shader, material) => {
        const isWaveDice = (material.userData?.diceTexture?.name ?? "").includes("ripper-premium-dice-waves");
        if (!isWaveDice) return;
        const colorBG = new PIXI.Color(material.userData?.materialData?.background || "#ffffff");
        const rgbBG = [colorBG.red, colorBG.green, colorBG.blue];

        shader.fragmentShader = shader.fragmentShader.replace("#include <map_fragment>", SHADERS.PATTERN_WAVE.fragment);
        shader.uniforms.time = { value: 0 };
        shader.uniforms.uColor = { value: rgbBG };

        shader.fragmentShader = `uniform float time;\nuniform vec3 uColor;\n` + shader.fragmentShader;
        TRACKED_SHADERS.push(shader);
    });

    Hooks.on("diceSoNiceOnMaterialReady", (material, cacheString) => {
        const isWaveDice = (material.userData?.diceTexture?.name ?? "").includes("ripper-premium-dice-waves");
        if (!isWaveDice) return;
        material.customProgramCacheKey = () => {return "ripper-premium-dice-waves"};
    });
}

const SHADERS = {
    PATTERN_WAVE: {
        fragment: `
        #include <map_fragment>
        vec2 uv = vMapUv * 12.0;
        float time_speed = time * 0.002;
        diffuseColor.rgb *= uColor;

        vec4 v1 = vec4(.1,.4,.222,0) + time_speed + atan(uv.y, uv.x);
        vec4 v2 = vec4(v1.x, v1.y, v1.z, v1.w) + vec4(0.0,1.0,2.0,3.0);


        v1 = cos( sin(uv.x)-cos(uv.y) + v1 ),
        v2 = sin( v1*uv.x*uv.y - uv.y + v2 );
    
        v1 =  abs(v2*v2-v1*v1);
    
        vec4 final = 1.6 * pow(1.0 -v1+v1*v1,  16.0+v1-v1);
        float intensity = (final.r + final.g + final.b) / 3.0;
        intensity = pow(0.5 + 0.5 * intensity, 2.0);
        diffuseColor.rgb *= intensity;
        `,
    },
};
